﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class InitialKeyboardIndicators : UserControl,IControl,ICorrespondenceOS
    {
        private InitialKeyboardIndicatorsController initialKeyboardIndicatorsController;

        public InitialKeyboardIndicators()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,     
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetInitialKeyboardIndicatorsState(bool b)
        {
            checkBox1.Checked = b;
        }


        public int GetInitialKeyboardIndicatorsState()
        {
            if (checkBox1.Checked)
            {
                return 2;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            initialKeyboardIndicatorsController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return initialKeyboardIndicatorsController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void InitialKeyboardIndicators_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            initialKeyboardIndicatorsController = new InitialKeyboardIndicatorsController(this,
                                                                        (IInitialKeyboardIndicatorsStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new InitialKeyboardIndicatorsDefaultStrategy()
                                                                                 }));
            initialKeyboardIndicatorsController.Read();
        }
    }
}
